/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFFlatWave;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.JellyshroomCapBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class JellyshroomFeature
extends DefaultFeature {
    private static final Function<class_2680, Boolean> REPLACE;
    private static final List<class_1160> ROOT;

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        if (!world.method_8320(pos.method_10074()).method_26164(class_3481.field_21953)) {
            return false;
        }
        class_2680 bark = EndBlocks.JELLYSHROOM.getBark().method_9564();
        class_2680 membrane = EndBlocks.JELLYSHROOM_CAP_PURPLE.method_9564();
        int height = MHelper.randRange((int)5, (int)8, (class_5819)random);
        float radius = (float)height * MHelper.randRange((float)0.15f, (float)0.25f, (class_5819)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)height, (float)0.0f, (int)3);
        SplineHelper.offsetParts((List)spline, (class_5819)random, (float)0.5f, (float)0.0f, (float)0.5f);
        SDF sdf = SplineHelper.buildSDF((List)spline, (float)radius, (float)0.8f, bpos -> bark);
        radius = (float)height * MHelper.randRange((float)0.7f, (float)0.9f, (class_5819)random);
        if (radius < 1.5f) {
            radius = 1.5f;
        }
        float membraneRadius = radius;
        SDF cap = this.makeCap(membraneRadius, random, membrane);
        class_1160 last = (class_1160)spline.get(spline.size() - 1);
        cap = new SDFTranslate().setTranslate(last.method_4943(), last.method_4945(), last.method_4947()).setSource(cap);
        sdf = new SDFSmoothUnion().setRadius(3.0f).setSourceA(sdf).setSourceB(cap);
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (EndBlocks.JELLYSHROOM.isTreeLog(info.getState())) {
                if (EndBlocks.JELLYSHROOM.isTreeLog(info.getStateUp()) && EndBlocks.JELLYSHROOM.isTreeLog(info.getStateDown())) {
                    return EndBlocks.JELLYSHROOM.getLog().method_9564();
                }
            } else if (info.getState().method_27852(EndBlocks.JELLYSHROOM_CAP_PURPLE)) {
                float dx = (float)(info.getPos().method_10263() - pos.method_10263()) - last.method_4943();
                float dz = (float)(info.getPos().method_10260() - pos.method_10260()) - last.method_4947();
                float distance = MHelper.length((float)dx, (float)dz) / membraneRadius * 7.0f;
                int color = class_3532.method_15340((int)MHelper.floor((double)distance), (int)0, (int)7);
                return (class_2680)info.getState().method_11657((class_2769)JellyshroomCapBlock.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((class_5425)world, pos);
        radius = (float)height * 0.5f;
        this.makeRoots(world, pos.method_10069(0, 2, 0), radius, random, bark);
        return true;
    }

    private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random, class_2680 wood) {
        int count = (int)(radius * 3.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (class_5819)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            class_1160 last = (class_1160)branch.get(branch.size() - 1);
            if (!world.method_8320(pos.method_10080((double)last.method_4943(), (double)last.method_4945(), (double)last.method_4947())).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
            SplineHelper.fillSpline((List)branch, (class_5281)world, (class_2680)wood, (class_2338)pos, REPLACE);
        }
    }

    private SDF makeCap(float radius, class_5819 random, class_2680 cap) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(cap);
        SDFUnary sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource((SDF)sphere);
        float angle = random.method_43057() * ((float)Math.PI * 2);
        int count = (int)MHelper.randRange((float)(radius * 0.5f), (float)radius, (class_5819)random);
        if (count < 3) {
            count = 3;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.2f).setSource((SDF)sphere);
        return sphere;
    }

    static {
        ROOT = Lists.newArrayList((Object[])new class_1160[]{new class_1160(0.1f, 0.7f, 0.0f), new class_1160(0.3f, 0.3f, 0.0f), new class_1160(0.7f, 0.05f, 0.0f), new class_1160(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (class_1160)new class_1160(0.0f, -0.45f, 0.0f));
        REPLACE = state -> {
            if (state.method_26207().equals(class_3614.field_15935)) {
                return true;
            }
            return state.method_26207().method_15800();
        };
    }
}

